package com.vf106.tools.activity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RadioGroup;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.dxiot.read.idcard.listener.OnReadCardListener;
import com.dxiot.read.idcard.service.ReadCardService;
import com.vf106.tools.R;
import com.vf106.tools.activity.base.BaseActivity;
import com.vf106.tools.utils.Constants;
import com.vf106.tools.utils.Utils;

/**
 * Swipe Test
 */
public class CardTestActivity extends BaseActivity implements RadioGroup.OnCheckedChangeListener, View.OnClickListener {
    private static final String TAG = "CardTestActivity";
    private boolean isStart;

    private RadioGroup rg_card_type;

    private LinearLayout ll_card_record;
    private LinearLayout ll_recognition_record;

    private TextView tv_content;
    private TextView tv_card_success_count;
    private TextView tv_card_fail_count;
    private TextView tv_recognition_success_count;
    private TextView tv_recognition_fail_count;

    private ScrollView sv_content;

    private Button btn_clear;

    private ReadCardService readCardService;

    //Record the number of successful card swipes
    private long cardSuccessCount;

    private long idCardSuccessCount;

    //Record the number of failed ID swipes for identification
    private long idCardFailCount;

    /**
     * Identity card identification reading
     */
    private boolean isReadCardFlag = false;

    private int cardType;

    private LinearLayout llRight;
    private LinearLayout llWrong;
    private int position;
    private int state;
    private String name;

    @Override
    protected void setContentView() {
        setContentView(R.layout.activity_card_test);
    }

    @Override
    protected void initViews() {
        ReadCardService.getInstance().init(getApplicationContext());
        readCardService = ReadCardService.getInstance();

        Intent intent = getIntent();
        position = intent.getIntExtra("position", 0);
        name = intent.getStringExtra("name");
        state = intent.getIntExtra("state", 0);
        llRight = findViewById(R.id.ll_right);
        llWrong = findViewById(R.id.ll_wrong);
        rg_card_type = findViewById(R.id.rg_card_type);
        ll_card_record = findViewById(R.id.ll_card_record);
        ll_recognition_record = findViewById(R.id.ll_recognition_record);

        tv_content = findViewById(R.id.tv_content);

        tv_card_success_count = findViewById(R.id.tv_card_success_count);
        tv_card_fail_count = findViewById(R.id.tv_card_fail_count);
        tv_recognition_success_count = findViewById(R.id.tv_recognition_success_count);
        tv_recognition_fail_count = findViewById(R.id.tv_recognition_fail_count);

        btn_clear = findViewById(R.id.btn_clear);
        sv_content = findViewById(R.id.sv_content);
        setListener();
    }

    @Override
    protected void setTitle() {
        setActionBarTitle("Swipe Function Test");
    }

    @Override
    protected void setListener() {
        rg_card_type.setOnCheckedChangeListener(this);
        readCardService.setOnReadCardListener(new OnReadCardListener() {

            @Override
            public void onReadCardSuccess(String result) {
                Log.i(TAG, "read card number==>" + result);
                if (TextUtils.isEmpty(result)) {
                    return;
                }

                runOnUiThread(() -> {
                    cardSuccessCount++;
                    appendLog(result);
                    tv_card_success_count.setText(cardSuccessCount + "\t");
                });
            }

            @Override
            public void onSuccess(String result) {
                isReadCardFlag = false;
                Log.i(TAG, result);
                if (TextUtils.isEmpty(result)) {
                    return;
                }

                runOnUiThread(() -> {
                    idCardSuccessCount++;
                    appendLog(result);
                    tv_recognition_success_count.setText(idCardSuccessCount + "\t");
                });
            }

            @Override
            public void onFailed(int code, String msg, String bizId) {
                isReadCardFlag = false;
                toast("ID card reading failed: error code =" + code);

                runOnUiThread(() -> {
                    idCardFailCount++;
                    tv_recognition_fail_count.setText(idCardFailCount + "\t");
                });

            }

            @Override
            public void onReadCardStart() {
                if (!isReadCardFlag) {
                    isReadCardFlag = true;
                    toast("Start reading. Do not move.");
                }
            }
        });

        llRight.setOnClickListener(this);
        llWrong.setOnClickListener(this);
    }

    @Override
    protected void initViewData() {

    }

    @Override
    protected void onResume() {
        super.onResume();
        if (!isNetworkConnected(CardTestActivity.this)) {
            toast("Card swipe failed, network not connected, please check the network");
        }
    }

    public void start(View view) {
        isStart = !isStart;
        if (isStart) {
            startTest((Button) view);
        } else {
            stopTest((Button) view);
        }
    }

    public void clear(View view) {
        tv_content.setText("");
        tv_card_success_count.setText("");
        tv_card_fail_count.setText("");
        tv_recognition_success_count.setText("");
        tv_recognition_fail_count.setText("");

        cardSuccessCount = 0;
        idCardSuccessCount = 0;
        idCardFailCount = 0;
    }

    public void clearLog(View view) {
        tv_content.setText("");
    }

    @Override
    public void onCheckedChanged(RadioGroup group, int checkedId) {
        if (checkedId == R.id.rb_normal_card) {
            ll_recognition_record.setVisibility(View.GONE);
            cardType = ReadCardService.NORMAL_CARD;

        } else if (checkedId == R.id.rb_id_card) {
            ll_recognition_record.setVisibility(View.VISIBLE);
            cardType = ReadCardService.ID_CARD;
        }

        clear(null);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (readCardService != null) {
            readCardService.release();
        }
    }

    private void appendLog(String content) {
        if (tv_content.getText().length() > 100000) {
            tv_content.setText("");
        }
        tv_content.append(Utils.getTime(System.currentTimeMillis()) + ":\t[" + content + "]\n");
        sv_content.fullScroll(View.FOCUS_DOWN);
    }

    private void startTest(Button button) {
        button.setText("Stop testing");
        rg_card_type.setEnabled(false);
        rg_card_type.getChildAt(0).setEnabled(false);
        rg_card_type.getChildAt(1).setEnabled(false);

        btn_clear.setEnabled(false);

        readCardService.start(cardType);
    }

    private void stopTest(Button button) {
        button.setText("Starting Tests");
        rg_card_type.setEnabled(true);
        rg_card_type.getChildAt(0).setEnabled(true);
        rg_card_type.getChildAt(1).setEnabled(true);

        btn_clear.setEnabled(true);

        readCardService.stop();
    }

    public void toast(String s) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Toast.makeText(CardTestActivity.this, s, Toast.LENGTH_SHORT).show();
            }
        });
    }

    /**
     * Network Status Determination
     */
    public boolean isNetworkConnected(Context context) {
        if (context != null) {
            ConnectivityManager mConnectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
            @SuppressLint("MissingPermission") NetworkInfo mNetworkInfo = mConnectivityManager.getActiveNetworkInfo();
            if (mNetworkInfo != null) {
                return mNetworkInfo.isAvailable();
            }
        }
        return false;
    }

    @SuppressLint("NonConstantResourceId")
    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.ll_right:
                state = 1;
                setIntentData();
                break;
            case R.id.ll_wrong:
                state = 2;
                setIntentData();
                break;
        }
    }

    public void setIntentData() {
        Intent intent = new Intent();
        intent.putExtra("name", name);
        intent.putExtra("state", state);
        intent.putExtra("position", position);
        setResult(Constants.resultCode, intent);
        finish();
    }
}
